#!/bin/sh

case "$1" in
  start)
    # increase buffers
    sysctl -w net.core.rmem_max=26214400
    sysctl -w net.core.rmem_default=26214400
    # sicherstellen dass zu den entsprechenden IPs die Verbindung über der richtigen Port läuft
    route add -host 192.168.2.87 dev eth1
    route add -host 192.168.2.79 dev eth1
    route add -host 192.168.2.91 dev eth1
    route add -host 192.168.2.92 dev eth1
    route add -host 192.168.2.93 dev eth1
    route add -host 192.168.2.94 dev eth1
    route add -host 192.168.2.95 dev eth1
    route add -host 192.168.2.96 dev eth1
    route add -host 192.168.2.97 dev eth1
    route add -host 192.168.2.98 dev eth1
    route add -host 192.168.2.81 dev eth0
    sleep 1
    # start vMobile
    echo -n "Starting visy-AFAS"
    /opt/visy/afas2/bin/run_initd.sh
    sleep 1
    # Disable the splash screen. First looking for a valid panel.
    # If no panel is connected to mainboard and the echo to splash_state
    # is executed no login is possible (neither via serial nor ssh).
    PANEL=`dmesg |grep ifm-panel`
    if [ -n "$PANEL" ]; then
        echo 0 > /sys/devices/platform/amba_pl/a00e0000.displaycontroller/splash_state
    fi
    ;;
  stop)
    echo -n "Stopping visy-AFAS"
    /opt/visy/afas2/bin/stop_initd.sh
    ;;
  restart)
    $0 stop
    sleep 1
    $0 start
    ;;
  *)
    echo "Usage: $0 {start|stop|restart}"
    exit 1
    ;;
esac

