#!/bin/sh
FILE_WESTON=/usr/bin/weston
LOCAL_DIR=/opt/visy/afas2/bin

# ======================================================================================
echo "setup environment ..."
# ======================================================================================
if [ -f "$FILE_WESTON" ]; then
    echo is_wayland...
    export XDG_RUNTIME_DIR="/run/user/0"
    export QT_QPA_PLATFORM=wayland-egl
    export QT_WAYLAND_SHELL_INTEGRATION=ivi-shell

    # vTrax-demo laueft immer auf SCREEN 0, LAYER 3, SURFACE 3
    export QT_IVI_SURFACE_ID=2
    export QT_VTRAX_IVI_LAYER_ID=2
    export QT_VTRAX_QML_FRAMELESS=1
    export QT_VTRAX_QML_FULLSCREEN=1

    LayerManagerControl destroy layer $QT_VTRAX_IVI_LAYER_ID
    LayerManagerControl create layer $QT_VTRAX_IVI_LAYER_ID 800 480
    LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID destination region 0 0 800 480
    LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID visibility 1
    LayerManagerControl set screen 0 render order 3,2,1


else
   echo is_x11
   export DISPLAY=:0
   export QT_DEVICE_PIXEL_RATIO=1
fi

export LD_LIBRARY_PATH=/opt/visy/opencv/lib/:/opt/visy/turbojpeg/lib:$LOCAL_DIR:$LD_LIBRARY_PATH
export QT_PLUGIN_PATH=:$QT_PLUGIN_PATH

killall afas2
killall vtools-afas
sleep 1
/opt/visy/afas2/bin/afas2 $1
