#!/bin/sh

case "$1" in
  start)
    mkdir /opt/persistent
    echo $(TZ="Europe/Berlin" date +"%Y-%m-%d %H:%M:%S MEZ")' - start hmi v20240910' >> /opt/persistent/booting.log
    # increase buffers
    sysctl -w net.core.rmem_max=26214400
    sysctl -w net.core.rmem_default=26214400
    # set correct ip of eth1
    ifconfig eth1 192.168.2.99 netmask 255.255.255.0
    ifconfig eth0 192.168.2.83 netmask 255.255.255.0
    # put resolv entry
    echo "nameserver 192.168.2.81" > /etc/resolv.conf
    # sicherstellen dass zu den entsprechenden IPs die Verbindung ..ber der richtigen Port l..uft
    route add -host 192.168.2.87 dev eth1
    route add -host 192.168.2.79 dev eth1
    route add -host 192.168.2.91 dev eth1
    route add -host 192.168.2.92 dev eth1
    route add -host 192.168.2.93 dev eth1
    route add -host 192.168.2.94 dev eth1
    route add -host 192.168.2.95 dev eth1
    route add -host 192.168.2.96 dev eth1
    route add -host 192.168.2.97 dev eth1
    route add -host 192.168.2.98 dev eth1
    route add -host 192.168.2.81 dev eth0
    route add default gw 192.168.2.81 dev eth0
    # add local port redirection : port 13101 = Portal-API, port 13102 = Log-API
    /opt/visy/afas2/bin/tcpfwd 192.168.2.99:13101 178.63.30.207:443 -d
    /opt/visy/afas2/bin/tcpfwd 192.168.2.99:13102 176.9.21.34:443 -d

    # usb identifizieren
    cp /media/usb/sda1/visy.usb /tmp/visy.usb
    sleep 1
    echo $(TZ="Europe/Berlin" date +"%Y-%m-%d %H:%M:%S MEZ")' - start hmi (open apps)' >> /opt/persistent/booting.log
    echo -n "Starting visy-AFAS"
    /opt/visy/afas2/bin/run_initd.sh
    sleep 1
    # start vMobile
    # echo -n "Starting vMobile"
    # /opt/visy/vMobile/bin/run_initd.sh
    # sleep 1
    # Disable the splash screen. First looking for a valid panel.
    # If no panel is connected to mainboard and the echo to splash_state
    # is executed no login is possible (neither via serial nor ssh).
    PANEL=`dmesg |grep ifm-panel`
    if [ -n "$PANEL" ]; then
        echo 0 > /sys/devices/platform/amba_pl/a00e0000.displaycontroller/splash_state
    fi
    echo $(TZ="Europe/Berlin" date +"%Y-%m-%d %H:%M:%S MEZ")' - start hmi (running)' >> /opt/persistent/booting.log
    ;;
  stop)
    echo $(TZ="Europe/Berlin" date +"%Y-%m-%d %H:%M:%S MEZ")' - shutdown hmi (close apps)' >> /opt/persistent/booting.log
    echo -n "Stopping vMobile"
    /opt/visy/vMobile/bin/stop_initd.sh
    echo -n "Stopping visy-AFAS"
    /opt/visy/afas2/bin/stop_initd.sh
    echo $(TZ="Europe/Berlin" date +"%Y-%m-%d %H:%M:%S MEZ")' - shutdown hmi (exit)' >> /opt/persistent/booting.log
    ;;
  restart)
    $0 stop
    sleep 1
    $0 start
    ;;
  *)
    echo "Usage: $0 {start|stop|restart}"
    exit 1
    ;;
esac


