#!/bin/sh

case "$1" in
  start)
    echo -n "Starting setup-launcher"
    export QT_QPA_PLATFORM=wayland
    export XDG_RUNTIME_DIR="/run/user/0"
    export QT_WAYLAND_SHELL_INTEGRATION=ivi-shell
    export QT_IVI_SURFACE_ID=2097152
    setup-launcher &
    sleep 1
    # Disable the splash screen. First looking for a valid panel.
    # If no panel is connected to mainboard and the echo to splash_state
    # is executed no login is possible (neither via serial nor ssh).
    PANEL=`dmesg |grep ifm-panel`
    if [ -n "$PANEL" ]; then
        echo 0 > /sys/devices/platform/amba_pl/a00e0000.displaycontroller/splash_state
    fi
    ;;
  stop)
    echo -n "Stopping setup-launcher"
    killall setup-launcher
    ;;
  restart)
    $0 stop
    sleep 1
    $0 start
    ;;
  *)
    echo "Usage: $0 {start|stop|restart}"
    exit 1
    ;;
esac
