#!/bin/sh
export DISPLAY=:0
export QT_DEVICE_PIXEL_RATIO=1

### variable from pam_systemd: tells a program started by the user where to store temporary files
export XDG_RUNTIME_DIR="/run/user/0"

### variable determines the platform plugin to be used
export QT_QPA_PLATFORM=wayland

### variable determines which shell is used
export QT_WAYLAND_SHELL_INTEGRATION=ivi-shell

### variable assigns a surface id to the qt-application
export QT_IVI_SURFACE_ID=7

export QT_WAYLAND_DISABLE_WINDOWDECORATION=1

### OLD AFAS Start Stuff
killall afas2
sleep 1
if [ -e /opt/visy/bin/active-1 ] 
then
  export LD_LIBRARY_PATH=/opt/visy/opencv/lib/:/opt/visy/bin/1
  /opt/visy/bin/1/afas2 -b
  if pidof afas2 > /dev/null
  then
    echo "afas2(1) started"
  else
    export LD_LIBRARY_PATH=/opt/visy/opencv/lib/:/opt/visy/bin/2
    /opt/visy/bin/2/afas2 -b
    sleep 2
    if pidof afas2 > /dev/null
    then
      echo "afas2(2) started"
    else
      export LD_LIBRARY_PATH=/opt/visy/opencv/lib/:/opt/visy/bin
      /opt/visy/bin/afas2 -b
      sleep 2
      if pidof afas2 > /dev/null
      then
        echo "afas2 started"
      else
        echo "afas2 not running"
      fi
    fi
  fi
else
  export LD_LIBRARY_PATH=/opt/visy/opencv/lib/:/opt/visy/bin/2
  /opt/visy/bin/2/afas2 -b
  if pidof afas2 > /dev/null
  then                                  
    echo "afas2(2) started"                
  else                                  
    export LD_LIBRARY_PATH=/opt/visy/opencv/lib/:/opt/visy/bin/1
    /opt/visy/bin/1/afas2 -b
    sleep 2                             
    if pidof afas2 > /dev/null          
    then                                
      echo "afas2(1) started"              
    else                                
      export LD_LIBRARY_PATH=/opt/visy/opencv/lib/:/opt/visy/bin  
      /opt/visy/bin/afas2 -b
      sleep 2
      if pidof afas2 > /dev/null        
      then                              
        echo "afas2 started"            
      else                              
        echo "afas2 not running"        
      fi            
    fi                                  
  fi
fi

### create layer with id 1 and add 1 surface to the layer
layer-add-surfaces 1 1

### set input focus (keys, touch, mouse) to surface with ID 7
LayerManagerControl set surfaces 7 input focus all


