#!/bin/sh
FILE_WESTON=/usr/bin/weston
LOCAL_DIR=/opt/visy/bin

# ======================================================================================
echo "setup environment ..."
# ======================================================================================
if [ -f "$FILE_WESTON" ]; then
   echo is_wayland...
   export XDG_RUNTIME_DIR="/run/user/0"
   export QT_QPA_PLATFORM=wayland-egl
   export QT_WAYLAND_SHELL_INTEGRATION=ivi-shell

   # vMobile laueft immer auf SCREEN 0, LAYER 3, SURFACE 3
   # afas2 = SCREEN 0, LAYER 2, SURFACE 2
   # afas2-watchdog SCREEN 0, LAYER 4, SURFACE 4
   # vtools-compress SCREEN 0, LAYER 5, SURFACE 5
   # vtools-upload SCREEN 0, LAYER 6, SURFACE 6
   export QT_IVI_SURFACE_ID=5
   export QT_VTRAX_IVI_LAYER_ID=5
   export QT_VTRAX_QML_FRAMELESS=1
   export QT_VTRAX_QML_FULLSCREEN=1

   LayerManagerControl destroy layer $QT_VTRAX_IVI_LAYER_ID
   LayerManagerControl create layer $QT_VTRAX_IVI_LAYER_ID 800 480
   LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID destination region 0 0 800 480
   LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID visibility 1
   LayerManagerControl set screen 0 render order 3,2,1

else
   echo is_x11
   export DISPLAY=:0
   export QT_DEVICE_PIXEL_RATIO=1
fi

export LD_LIBRARY_PATH=/opt/visy/opencv/lib/:/opt/visy/turbojpeg/lib:$LOCAL_DIR:$LD_LIBRARY_PATH
export QT_PLUGIN_PATH=:$QT_PLUGIN_PATH

# vtools-compress beenden
killall vtools-compress
if pidof vtools-compress > /dev/null
then
   sleep 1
fi

if pidof vtools-compress > /dev/null
then
   killall -s SIGKILL vtools-compress
   sleep 1
fi

if [ -e /opt/visy/bin/active-1 ]
then
  export LD_LIBRARY_PATH=/opt/visy/bin/1:$LD_LIBRARY_PATH
  /opt/visy/bin/1/vtools-compress --compress </dev/null &>/dev/null &
  if pidof vtools-compress > /dev/null
  then
    echo "vtools-compress(1) started"
  else
    export LD_LIBRARY_PATH=/opt/visy/bin/2:$LD_LIBRARY_PATH
    /opt/visy/bin/2/vtools-compress --compress </dev/null &>/dev/null &
    sleep 2
    if pidof vtools-compress > /dev/null
    then
      echo "vtools-compress(2) started"
    else
      export LD_LIBRARY_PATH=/opt/visy/bin:$LD_LIBRARY_PATH
      /opt/visy/bin/vtools-compress --compress </dev/null &>/dev/null &
      sleep 2
      if pidof vtools-compress > /dev/null
      then
        echo "vtools-compress started"
      else
        echo "vtools-compress not running"
      fi
    fi
  fi
else
  export LD_LIBRARY_PATH=/opt/visy/bin/2:$LD_LIBRARY_PATH
  /opt/visy/bin/2/vtools-compress --compress </dev/null &>/dev/null &
  if pidof vtools-compress > /dev/null
  then
    echo "vtools-compress(2) started"
  else
    export LD_LIBRARY_PATH=/opt/visy/bin/1:$LD_LIBRARY_PATH
    /opt/visy/bin/1/vtools-compress --compress </dev/null &>/dev/null &
    sleep 2
    if pidof vtools-compress > /dev/null
    then
      echo "vtools-compress(1) started"
    else
      export LD_LIBRARY_PATH=/opt/visy/bin:$LD_LIBRARY_PATH
      /opt/visy/bin/vtools-compress --compress </dev/null &>/dev/null &
      sleep 2
      if pidof vtools-compress > /dev/null
      then
        echo "vtools-compress started"
      else
        echo "vtools-compress not running"
      fi
    fi
  fi
fi
