#!/bin/sh

case "$1" in
  start)
    echo -n "Starting visy-AFAS"
    /opt/visy/bin/run_initd.sh
    sleep 2
    # Disable the splash screen. First looking for a valid panel.
    # If no panel is connected to mainboard and the echo to splash_state
    # is executed no login is possible (neither via serial nor ssh).
    PANEL=`dmesg |grep ifm-panel`
    if [ -n "$PANEL" ]; then
        echo 0 > /sys/devices/platform/amba_pl/a00e0000.displaycontroller/splash_state
    fi
    ;;
  stop)
    echo -n "Stopping visy-AFAS"
    /opt/visy/bin/stop_initd.sh
    ;;
  restart)
    $0 stop
    sleep 1
    $0 start
    ;;
  *)
    echo "Usage: $0 {start|stop|restart}"
    exit 1
    ;;
esac

