#!/bin/sh

case "$1" in
  start)
    # increase buffers
    sysctl -w net.core.rmem_max=26214400
    sysctl -w net.core.rmem_default=26214400
    # start vMobile
    echo -n "Starting vMobile"
    /opt/visy/vMobile/bin/run_initd.sh
    sleep 2
    # Disable the splash screen. First looking for a valid panel.
    # If no panel is connected to mainboard and the echo to splash_state
    # is executed no login is possible (neither via serial nor ssh).
    PANEL=`dmesg |grep ifm-panel`
    if [ -n "$PANEL" ]; then
        echo 0 > /sys/devices/platform/amba_pl/a00e0000.displaycontroller/splash_state
    fi
    ;;
  stop)
    echo -n "Stopping vMobile"
    /opt/visy/vMobile/bin/stop_initd.sh
    ;;
  restart)
    $0 stop
    sleep 1
    $0 start
    ;;
  *)
    echo "Usage: $0 {start|stop|restart}"
    exit 1
    ;;
esac

