#!/bin/sh
FILE_WESTON=/usr/bin/weston
LOCAL_DIR=/opt/visy/vMobile/bin

# ======================================================================================
echo "setup environment ..."
# ======================================================================================
if [ -f "$FILE_WESTON" ]; then
   echo is_wayland...
   export XDG_RUNTIME_DIR="/run/user/0"
   export QT_QPA_PLATFORM=wayland-egl
   export QT_WAYLAND_SHELL_INTEGRATION=ivi-shell

   # vMobile-watchdog laueft immer auf SCREEN 0, LAYER 5, SURFACE 5
   export QT_IVI_SURFACE_ID=5
   export QT_VTRAX_IVI_LAYER_ID=5
   export QT_VTRAX_QML_FRAMELESS=1
   export QT_VTRAX_QML_FULLSCREEN=1

   LayerManagerControl destroy layer $QT_VTRAX_IVI_LAYER_ID
   LayerManagerControl create layer $QT_VTRAX_IVI_LAYER_ID 800 480
   LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID destination region 0 0 800 480
   LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID visibility 1
   LayerManagerControl set screen 0 render order 3,2,1

else
   echo is_x11
   export DISPLAY=:0
   export QT_DEVICE_PIXEL_RATIO=1
fi

export LD_LIBRARY_PATH=/opt/visy/opencv/lib/:/opt/visy/turbojpeg/lib:$LOCAL_DIR:$LD_LIBRARY_PATH
export QT_PLUGIN_PATH=:$QT_PLUGIN_PATH

killall vMobile-watchdog
sleep 1
if [ -e /opt/visy/vMobile/bin/active-1 ]
then
  export LD_LIBRARY_PATH=/opt/visy/vMobile/bin/1:$LD_LIBRARY_PATH
  /opt/visy/vMobile/bin/1/vMobile-watchdog -w -b
  if pidof vMobile-watchdog > /dev/null
  then
    echo "vMobile-watchdog(1) started"
  else
    export LD_LIBRARY_PATH=/opt/visy/vMobile/bin/2:$LD_LIBRARY_PATH
    /opt/visy/vMobile/bin/2/vMobile-watchdog -w -b
    sleep 2
    if pidof vMobile-watchdog > /dev/null
    then
      echo "vMobile-watchdog(2) started"
    else
      export LD_LIBRARY_PATH=/opt/visy/vMobile/bin:$LD_LIBRARY_PATH
      /opt/visy/vMobile/bin/vMobile-watchdog -w -b
      sleep 2
      if pidof vMobile-watchdog > /dev/null
      then
        echo "vMobile-watchdog started"
      else
        echo "vMobile-watchdog not running"
      fi
    fi
  fi
else
  export LD_LIBRARY_PATH=/opt/visy/vMobile/bin/2:$LD_LIBRARY_PATH
  /opt/visy/vMobile/bin/2/vMobile-watchdog -w -b
  if pidof vMobile-watchdog > /dev/null
  then
    echo "vMobile-watchdog(2) started"
  else
    export LD_LIBRARY_PATH=/opt/visy/vMobile/bin/1:$LD_LIBRARY_PATH
    /opt/visy/vMobile/bin/1/vMobile-watchdog -w -b
    sleep 2
    if pidof vMobile-watchdog > /dev/null
    then
      echo "vMobile-watchdog(1) started"
    else
      export LD_LIBRARY_PATH=/opt/visy/vMobile/bin:$LD_LIBRARY_PATH
      /opt/visy/vMobile/bin/vMobile-watchdog -w -b
      sleep 2
      if pidof vMobile-watchdog > /dev/null
      then
        echo "vMobile-watchdog started"
      else
        echo "vMobile-watchdog not running"
      fi
    fi
  fi
fi
