#!/bin/sh
FILE_WESTON=/usr/bin/weston
LOCAL_DIR=/opt/visy/vMobile/bin

# ======================================================================================
echo "setup environment ..."
# ======================================================================================
if [ -f "$FILE_WESTON" ]; then
   echo is_wayland...
   export XDG_RUNTIME_DIR="/run/user/0"
   export QT_QPA_PLATFORM=wayland-egl
   export QT_WAYLAND_SHELL_INTEGRATION=ivi-shell

   # vMobile laueft immer auf SCREEN 0, LAYER 3, SURFACE 3
   export QT_IVI_SURFACE_ID=3
   export QT_VTRAX_IVI_LAYER_ID=3
   export QT_VTRAX_QML_FRAMELESS=1
   export QT_VTRAX_QML_FULLSCREEN=1

    if [ -f /opt/is_cr1203 ]; then
       # settings für CR1203
       LayerManagerControl destroy layer $QT_VTRAX_IVI_LAYER_ID
       LayerManagerControl create layer $QT_VTRAX_IVI_LAYER_ID 480 480
       LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID destination region 800 0 480 480
       LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID visibility 1
       LayerManagerControl set screen 0 render order 3,2,1
    else
       if [ -f /opt/is_cr1102 ]; then
          # Settings für is_cr1102
          LayerManagerControl destroy layer $QT_VTRAX_IVI_LAYER_ID
          LayerManagerControl create layer $QT_VTRAX_IVI_LAYER_ID 1280 800
          LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID destination region 0 0 1280 800
          LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID visibility 1
          LayerManagerControl set screen 0 render order 3,2,1
       else
          # Settings für CR1075/CR1077
          LayerManagerControl destroy layer $QT_VTRAX_IVI_LAYER_ID
          LayerManagerControl create layer $QT_VTRAX_IVI_LAYER_ID 800 480
          LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID destination region 0 0 800 480
          LayerManagerControl set layer $QT_VTRAX_IVI_LAYER_ID visibility 1
          LayerManagerControl set screen 0 render order 3,2,1
       fi
fi

else
   echo is_x11
   export DISPLAY=:0
   export QT_DEVICE_PIXEL_RATIO=1
fi

export LD_LIBRARY_PATH=/opt/visy/opencv/lib/:/opt/visy/turbojpeg/lib:$LOCAL_DIR:$LD_LIBRARY_PATH
export QT_PLUGIN_PATH=:$QT_PLUGIN_PATH

killall vMobile
sleep 1
if [ -e /opt/visy/vMobile/bin/active-1 ]
then
  export LD_LIBRARY_PATH=/opt/visy/vMobile/bin/1:$LD_LIBRARY_PATH
  /opt/visy/vMobile/bin/1/vMobile -b
  if pidof vMobile > /dev/null
  then
    echo "vMobile(1) started"
  else
    export LD_LIBRARY_PATH=/opt/visy/vMobile/bin/2:$LD_LIBRARY_PATH
    /opt/visy/vMobile/bin/2/vMobile -b
    sleep 2
    if pidof vMobile > /dev/null
    then
      echo "vMobile(2) started"
    else
      export LD_LIBRARY_PATH=/opt/visy/vMobile/bin:$LD_LIBRARY_PATH
      /opt/visy/vMobile/bin/vMobile -b
      sleep 2
      if pidof vMobile > /dev/null
      then
        echo "vMobile started"
      else
        echo "vMobile not running"
      fi
    fi
  fi
else
  export LD_LIBRARY_PATH=/opt/visy/vMobile/bin/2:$LD_LIBRARY_PATH
  /opt/visy/vMobile/bin/2/vMobile -b
  if pidof vMobile > /dev/null
  then
    echo "vMobile(2) started"
  else
    export LD_LIBRARY_PATH=/opt/visy/vMobile/bin/1:$LD_LIBRARY_PATH
    /opt/visy/vMobile/bin/1/vMobile -b
    sleep 2
    if pidof vMobile > /dev/null
    then
      echo "vMobile(1) started"
    else
      export LD_LIBRARY_PATH=/opt/visy/vMobile/bin:$LD_LIBRARY_PATH
      /opt/visy/vMobile/bin/vMobile -b
      sleep 2
      if pidof vMobile > /dev/null
      then
        echo "vMobile started"
      else
        echo "vMobile not running"
      fi
    fi
  fi
fi
